﻿using gov.va.med.vbecs.BOL;
using gov.va.med.vbecs.Common;
using gov.va.med.vbecs.GUI;
using System.Collections.Generic;
using System.Linq;
using System.Windows;

namespace WPF.PresentationLayer.UC115.ViewModels
{
    public class PatientTASViewModel : SpecimenTabViewModel
    {
        public IEnumerable<SpecimenItemViewModel> PendingPatientABOList
        {
            get
            {
                return PendingSpecimenList.Where(x => x.PendingTestModel is PendingSpecimenAboRhModel);
            }
        }

        public IEnumerable<SpecimenItemViewModel> PendingPatientABSList
        {
            get
            {
                return PendingSpecimenList.Where(x => x.PendingTestModel is PendingSpecimenAbsModel);
            }
        }

        public Visibility SC1Visibility { get; private set; }
        public Visibility SC2Visibility { get; private set; }
        public Visibility SC3Visibility { get; private set; }
        public Visibility SC4Visibility { get; private set; }
        public Visibility SC5Visibility { get; private set; }

        public PatientTASViewModel(
            Patient patient, 
            string specimentUid, 
            VbecsBaseForm vbecsBaseForm,
            IEnumerable<PendingSpecimenTasModel> pendingSpecimenTasTestList)
            : base(patient, specimentUid, vbecsBaseForm, null, StrRes.HelpFiles.UC115.AutomatedTestingPatientTasTab())
        {
            // Separate the Abo/Rh objects from the 
            var aboRhList = pendingSpecimenTasTestList.Where(w => w.PendingSpecimenAboRhModel != null)
                                                      .Select(x => new SpecimenItemViewModel(x.PendingSpecimenAboRhModel));
            var absList = pendingSpecimenTasTestList.Where(w => w.PendingSpecimenAbsModel != null)
                                                    .Select(x => x.PendingSpecimenAbsModel);
            var absVMList = absList.Select(x => new SpecimenItemViewModel(x));

            var fullList = aboRhList.ToObservableCollection();
            fullList.AddRange(absVMList.ToObservableCollection());
            base.SetPendingSpecimenList(fullList);

            PendingSpecimenList.CollectionChanged += PendingSpecimenList_CollectionChanged;

            // Toggle the column visibility based on if we have any data for the respective column
            SC1Visibility = absList.Any(x => x.SC1 != null) ? Visibility.Visible : Visibility.Collapsed;
            SC2Visibility = absList.Any(x => x.SC2 != null) ? Visibility.Visible : Visibility.Collapsed;
            SC3Visibility = absList.Any(x => x.SC3 != null) ? Visibility.Visible : Visibility.Collapsed;
            SC4Visibility = absList.Any(x => x.SC4 != null) ? Visibility.Visible : Visibility.Collapsed;
            SC5Visibility = absList.Any(x => x.SC5 != null) ? Visibility.Visible : Visibility.Collapsed;
        }

        void PendingSpecimenList_CollectionChanged(object sender, System.Collections.Specialized.NotifyCollectionChangedEventArgs e)
        {
            // Update the Grid data if the collection changed
            RaisePropertyChanged(() => PendingPatientABOList);
            RaisePropertyChanged(() => PendingPatientABSList);
        }
    }
}
